############################################################################
#####################        function define     ###########################
############################################################################
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

############################################################################
#########################      read in data       ##########################
############################################################################

ICM1_r1 <- read.table("../data/ICM1_r1.imprints.methyratio.txt",row.names=1)[,2]
ICM1_r2 <- read.table("../data/ICM1_r2.imprints.methyratio.txt",row.names=1)[,2]
ICM2 <- read.table("../data/ICM2.imprints.methyratio.txt",row.names=1)[,2]
ICM3 <- read.table("../data/ICM3.imprints.methyratio.txt",row.names=1)[,2]
# 2nd naive
hiFT <- read.table("../data/hiFT.imprints.methyratio.txt",row.names=1)[,2]
he6 <- read.table("../data/he6.imprints.methyratio.txt",row.names=1)[,2]
n12 <- read.table("../data/n12.imprints.methyratio.txt",row.names=1)[,2]
n12_r2 <- read.table("../data/n12_r2.imprints.methyratio.txt",row.names=1)[,2]
n20 <- read.table("../data/n20.imprints.methyratio.txt",row.names=1)[,2]
niPS <- read.table("../data/niPS.imprints.methyratio.txt",row.names=1)[,2]
n24_r2 <- read.table("../data/n24_r2.imprints.methyratio.txt",row.names=1)[,2]
n24_r1 <- read.table("../data/n24_r1.imprints.methyratio.txt",row.names=1)[,2]
# 2nd primed
p20 <- read.table("../data/p20.imprints.methyratio.txt",row.names=1)[,2]
p20_r2 <- read.table("../data/p20_r2.imprints.methyratio.txt",row.names=1)[,2]
p24 <- read.table("../data/p24.imprints.methyratio.txt",row.names=1)[,2]
p24_r2 <- read.table("../data/p24_r2.imprints.methyratio.txt",row.names=1)[,2]
piPS <- read.table("../data/piPS.imprints.methyratio.txt",row.names=1)[,2]

ICM <- c(ICM1_r1,ICM1_r2,ICM2,ICM3)
n24 <- c(n24_r1,n24_r2)
p20 <- c(p20,p20_r2)
p24 <- c(p24,p24_r2)

n_time_points <- c("hiFT","he6","n12","n20","n24","niPS")
labels <- c("hiFT-C","6d","n12","20d","24d","iPSC-T")

naive_path <- c("hiF-T","6d","20d","24d","niPSC-T","ICM")
primed_path <- c("hiF-T","6d","20d","24d","piPSC-T","ICM")
common_path <- c("hiF-T","6d","20d","24d","iPSC-T","ICM")

############################################################################
####################               plot            #########################
############################################################################
pdf("Fig5G.pdf",width=3,height=4)
par(mar=c(6,4,4,2))
n <- length(naive_path)
boxplot(hiFT,he6,n20,n24,niPS,ICM, at=c(0:(n-2)*3+1,(n-1)*3+1.5), xlim=c(0,n*3),col=c(rep(cccol[1],5),cccol[8]), xaxt="n", outline=F,main="imprints",ylab="DNA methylation ratio",xlab="",ylim=c(0,1),las=2)
boxplot(hiFT,he6,p20,p24,piPS, at=0:(n-2)*3+2, xaxt="n",yaxt="n", add=TRUE, outline=F,col=cccol[2],ylim=c(0,1))
abline(h=0.5,lty=2,col=cccol[8])
axis(1, at = 0:(n-1)*3 + 1.5, labels = common_path, tick = TRUE, las=2)
dev.off()
